//		Articulation points
////////////////////////////////////////////
/******************************************
			:::::Input:::::
list :  undirected network (LSCC)
sorted by first column in ascending rder

			:::::Output:::::
Joint point	the number of Division
********************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <string.h>

//Root node
#define root 1

//array
int *ll,*lr,*filter,*visited,*linenum;
int *prenum,*parent,*lowest,num;
int max;

double maximum(double aa,double bb);
double minimum(double aa,double bb);

main(int argc, char* argv[]) {
	
	int i,j;
	int Line;
	int x,y;
	
	//read list
	FILE *fp;
	
	ll=(int *)calloc(1,sizeof(int));
	lr=(int *)calloc(1,sizeof(int));
	filter=(int *)calloc(1,sizeof(int));
	
	Line=1;
	max=0;
	
	fp=fopen(argv[1],"r");
	while(fscanf(fp,"%d %d",&x,&y)!=EOF)
	{
	max=maximum(max,x);
	max=maximum(max,y);
	ll=(int *)realloc(ll,(Line+1)*sizeof(int));
	lr=(int *)realloc(lr,(Line+1)*sizeof(int));
	filter=(int *)realloc(filter,(max+1)*sizeof(int));
	ll[Line]=x;
	lr[Line]=y;
	filter[x]=1;
	filter[y]=1;
	Line++;
	}
	fclose(fp);
	//finish reading
	
	max++;
	
	//line which node i starts
	linenum=(int *)calloc(max+1,sizeof(int));
	for(i=1;i<Line;i++)
	{
		if(ll[i] != ll[i-1])
		{
			linenum[ll[i]]=i;
			if(ll[i] - ll[i-1] >1)
			{
				for(j=ll[i-1]+1;j<ll[i];j++)
				{
					linenum[j]=linenum[ll[i]];
				}
			}
		}
	}
	linenum[max]=Line;
	//nodei
	
	//DFS
	int *NumChil,*scc;
	
	prenum=(int *)calloc(max,sizeof(int));
	parent=(int *)calloc(max,sizeof(int));
	lowest=(int *)calloc(max,sizeof(int));
	NumChil=(int *)calloc(max,sizeof(int));
	
	num = 0;
	for (i = 1; i < max; i++ )
	{
		prenum[i] = -1;
	}
	dfs( root, 0 );
	//DFS
	
	//the number of Division
	scc=(int *)calloc(max,sizeof(int));
	for(i=1;i<max;i++)
	{
		NumChil[parent[i]]+=1;
	}
	for(i=1;i<max;i++)
	{
		if(i==root)
		{
			if(NumChil[root]>1)
			scc[root]+=1;
		}
		else{
			if(parent[i]!=root && prenum[parent[i]]<=lowest[i])
			scc[parent[i]]+=1;
		}
	}
	//finish : the numebr of division
	
	//output
	for(i=1;i<max;i++)
	{
		if(scc[i]>0)
		printf("%d %d\n",i,scc[i]+1);
	}
	//output
	
	free(ll);
	free(lr);
	free(filter);
	free(linenum);
	free(prenum);
	free(parent);
	free(lowest);
	free(NumChil);
}

dfs( int current, int prev ){

	int t;
    // the procedure after visiting the  current node
	// give the visiting number
    prenum[current] = num; 
	lowest[current] = num;
    num++;

	for(t=linenum[current];t<linenum[current+1];t++)
	{
        if ( prenum[lr[t]]==-1 ){
            // the procedure before moving from node current to node next 
            parent[lr[t]] = current;
            dfs(lr[t], current );
            // the procedure after moving from node current to node next 
            lowest[current] = minimum( lowest[current], lowest[lr[t]] );
        } else if ( *(lr+t) != prev ){
            // if edge current --> next is Back-edge 
            lowest[current] = minimum( lowest[current], prenum[lr[t]] );
        }
    }
}

double maximum(double aa,double bb)
{
	if(aa>bb)
	{
		return(aa);
	}else{
		return(bb);
	}
}

double minimum(double aa,double bb)
{
	if(aa<bb)
	{
		return(aa);
	}else{
		return(bb);
	}
}
/******************************************
			:::::array:::::

ll[i]		the left-side number in the i-th line
lr[i]		the right-side number in the i-th line
filter[i]	1 (node i exists) , 0( not exists)
linenum[i]	the first line of node i in the left-side 
prenum[i]	the visiting order of node i in dfs
lowest[i]	the node group which is achievable from node i along theBackEdge
NumChil[i]	the num of node i 
scc[i]		the number of division ( node i : joint point)
********************************************/