#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#define size 9
#define Number 365

int matrix_inv( double x[size][size] , double inv[size][size]){
	double tmp;
	int i,j,pivot;
	double max;
	int max_row;
	
	
	for(i=0;i<size;i++){
		for(j=0;j<size;j++){
			inv[i][j] = (i==j)? 1.0 : 0.0 ;
		}
	}
	
	for( pivot=0 ; pivot<size ; pivot++ ){	//pivot
		
		max = 0.0;
		for(i= pivot ; i<size ; i++ ){
			if( fabs(x[i][pivot]) > max ){
				max = fabs(x[i][pivot]);
				max_row = i;
			}
		}
		if( max == 0.0 ){
			printf("not exist\a\n");
			return -1;
		}
		if( pivot != max_row ){
			for( j=0; j<size ; j++ ){
				tmp = x[pivot][j];
				x[pivot][j] = x[max_row][j];
				x[max_row][j] = tmp;
				
				tmp = inv[pivot][j];
				inv[pivot][j] = inv[max_row][j];
				inv[max_row][j] = tmp;
				
			}
		}
		
		
		
		tmp = 1.0/x[pivot][pivot];
		for(j=0;j<size ; j++){
			x[pivot][j] *= tmp;
			inv[pivot][j] *= tmp;
		}
		
		
		for(i=0;i<size; i++){	//for1
			if( pivot != i ){
				tmp = x[i][pivot];
				for( j = 0 ; j < size ; j ++){
					x[i][j] -= x[pivot][j]*tmp;
					inv[i][j] -= inv[pivot][j]*tmp;
				}
			}
		}	//for1
		
	}	//pivot
	
	for( i=0 ;i<size ; i++){
		for(j=0; j<size ; j++ ){
			if( inv[i][j] > pow(10,5) ){
				printf("incredible\a\n");
				return -1;
			}
		}
	}
	
	
	return 1;
}



int main( int argc, char *argv[]){
	int i,j;
	double a[size][size];
	double inv[size][size];
	
	FILE *fpr, *fpw,*fpt;
	fpr = fopen("problem4_3_1.dat","r");
	fpw = fopen("problem4_3_2.dat","w");
	fpt = fopen("problem4_3_2_t.dat", "w");
	
	int ret;
	for(i=0;i<size;i++){
		fscanf(fpr,"%lf	%lf	%lf	%lf	%lf	%lf	%lf	%lf	%lf",&a[0][i],&a[1][i],&a[2][i],&a[3][i],&a[4][i],&a[5][i],&a[6][i],&a[7][i],&a[8][i] );
	}
			
	int check = matrix_inv( a, inv);
	double tmp[size][size],t;
	if(check != -1 ){
		for( i=0 ;i<size ; i++){
			for( j=0 ; j<size ; j++ ){
				tmp[i][j] = -inv[i][j]/sqrt(inv[i][i] * inv[j][j]);
				fprintf(fpw,"%f	",  tmp[i][j] );
			}
			fprintf(fpw,"\n");
		}
		for( i=0 ;i<size ; i++){
			for( j=0 ; j<size ; j++ ){
				t = sqrt( pow(tmp[i][j],2) * (Number - size ))/sqrt( 1- pow(tmp[i][j] , 2) );
				fprintf(fpt,"%f	",  t);
			}
			fprintf(fpt,"\n");
		}
		
	}
	
	

	return 0;
}

