#!/bin/bash


gcc -o 	problem3_4_5.exe 	problem3_4_5.c 	dSFMT.c

./problem3_4_5.exe

#calculate the power index
c=2.2
index=$(echo "scale=3; l(2)/l(${c})" | bc -l | sed -e "s/^\./0\./g")

gnuplot <<EOF
set terminal postscript eps enhanced color
set output "problem3_4_5.eps"
set size 0.6,0.6
set xlabel "x"
set ylabel "CDF" 
set yrange [:1]
set log xy
set format x "10^{%L}"
set format y "10^{%L}"
plot	"problem3_4_5.dat" w l noti ,\
		x**-${index} w l title "x^{-${index}}"
EOF

