#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include"dSFMT.h"

#define Maxtime	pow(10,6)		//time
#define c		2.2				//parameter c
dsfmt_t dsfmt1;


int double_comp(const void *_a, const void *_b) {	//for qsort
	double a = *(double *)_a;
	double b = *(double *)_b;
	
	if (a > b)		return -1;
	else if (a < b)	return 1;
	else			return 0;
}


int main(void){
	dsfmt_init_gen_rand(&dsfmt1,1);
	int t, i ;
	double b;		//parmeter b
	double F = 1.0;	//parameter F
	double rand;
	double *x;		//position
	x = (double *)calloc( Maxtime, sizeof(double));
	
	FILE *fp;
	if( (fp=fopen("problem3_4_5.dat","w")) ==NULL){
		printf("FILE Error\n");
		exit(1);
	}
	for( t=1; t< Maxtime ; t++){	//trial
		rand = dsfmt_genrand_close_open(&dsfmt1);
		b= (rand > 0.5)? 0.0 : c;
		
		x[t] = b*x[t-1] + F;
	}
	
	qsort( x , Maxtime , sizeof(double) , double_comp);
	for(i = 0; i < Maxtime ; i++){
		fprintf( fp , "%f %f\n" , x[i] , (double)(i+1)/Maxtime );
	}
	
	return 0;
}


